/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.quests;

import java.util.HashMap;
import java.util.Objects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.DimensionManager;
import noppes.npcs.NBTTags;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.Server;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.IPos;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.entity.IPlayer;
import noppes.npcs.api.handler.data.IQuestObjective;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.constants.EnumQuestTask;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.data.Dialog;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.QuestData;
import noppes.npcs.util.ValueUtil;

public class QuestObjective
implements IQuestObjective {
    private boolean ignoreDamage = false;
    private boolean ignoreNBT = false;
    private boolean leaveItem = false;
    private boolean partName = false;
    private boolean andTitle = false;
    private boolean notShowLogEntity = false;
    private boolean setPointOnMiniMap = false;
    private int id = 0;
    private final int parentID;
    private int maxProgress = 1;
    private int range = 10;
    private EnumQuestTask type = EnumQuestTask.ITEM;
    private ItemStack item = ItemStack.field_190927_a;
    private String name = "";
    private final EntityPlayer player;
    public int regionID = -1;
    public int dimensionID = 0;
    public int rangeCompass = 5;
    public BlockPos pos = new BlockPos(0, 0, 0);
    public String entityName = "";

    public QuestObjective(int parentIDIn, EntityPlayer playerIn) {
        this.parentID = parentIDIn;
        this.player = playerIn;
    }

    public QuestObjective(int parentID, EnumQuestTask type) {
        this.parentID = parentID;
        this.type = type;
        this.player = null;
    }

    public QuestObjective copyToPlayer(EntityPlayer player) {
        QuestObjective newObj = new QuestObjective(this.parentID, player);
        newObj.type = this.type;
        newObj.maxProgress = this.maxProgress;
        newObj.id = this.id;
        newObj.range = this.range;
        newObj.name = this.name;
        newObj.item = this.item;
        newObj.leaveItem = this.leaveItem;
        newObj.ignoreDamage = this.ignoreDamage;
        newObj.ignoreNBT = this.ignoreNBT;
        newObj.setPointOnMiniMap = this.setPointOnMiniMap;
        newObj.partName = this.partName;
        newObj.andTitle = this.andTitle;
        newObj.notShowLogEntity = this.notShowLogEntity;
        newObj.pos = this.pos;
        newObj.dimensionID = this.dimensionID;
        newObj.rangeCompass = this.rangeCompass;
        newObj.entityName = this.entityName;
        return newObj;
    }

    @Override
    public int getAreaRange() {
        return this.range;
    }

    @Override
    public int getCompassDimension() {
        return this.dimensionID;
    }

    @Override
    public IPos getCompassPos() {
        return Objects.requireNonNull(NpcAPI.Instance()).getIPos(this.pos.func_177958_n(), this.pos.func_177956_o(), this.pos.func_177952_p());
    }

    @Override
    public int getCompassRange() {
        return this.rangeCompass;
    }

    public HashMap<ItemStack, Integer> getCrafted(QuestData data) {
        if (!data.extraData.func_150297_b("Crafts", 9)) {
            data.extraData.func_74782_a("Crafts", (NBTBase)new NBTTagList());
        }
        return NBTTags.getItemStackIntegerMap(data.extraData.func_150295_c("Crafts", 10));
    }

    public EnumQuestTask getEnumType() {
        return this.type;
    }

    @Override
    public IItemStack getItem() {
        return Objects.requireNonNull(NpcAPI.Instance()).getIItemStack(this.item);
    }

    public ItemStack getItemStack() {
        return this.item;
    }

    public HashMap<String, Integer> getKilled(QuestData data) {
        if (!data.extraData.func_150297_b("Targets", 9)) {
            data.extraData.func_74782_a("Targets", (NBTBase)new NBTTagList());
        }
        return NBTTags.getStringIntegerMap(data.extraData.func_150295_c("Targets", 10));
    }

    @Override
    public int getMaxProgress() {
        if (this.type == EnumQuestTask.DIALOG || this.type == EnumQuestTask.LOCATION) {
            return 1;
        }
        return this.maxProgress;
    }

    public NBTTagCompound getNBT() {
        NBTTagCompound nbtTask = new NBTTagCompound();
        nbtTask.func_74768_a("Type", this.type.ordinal());
        nbtTask.func_74757_a("SetPointOnMiniMap", this.setPointOnMiniMap);
        NBTTagCompound nbtCompass = new NBTTagCompound();
        nbtCompass.func_74783_a("Pos", new int[]{this.pos.func_177958_n(), this.pos.func_177956_o(), this.pos.func_177952_p()});
        nbtCompass.func_74768_a("DimensionID", this.dimensionID);
        nbtCompass.func_74768_a("RegionID", this.regionID);
        nbtCompass.func_74768_a("Range", this.rangeCompass);
        nbtCompass.func_74778_a("EntityName", this.entityName);
        nbtTask.func_74782_a("CompassData", (NBTBase)nbtCompass);
        if (this.maxProgress > 0) {
            nbtTask.func_74768_a("Progress", this.maxProgress);
        }
        if (this.id > 0) {
            nbtTask.func_74768_a("TargetID", this.id);
        }
        if (!this.name.isEmpty()) {
            nbtTask.func_74778_a("TargetName", this.name);
            nbtTask.func_74757_a("TargetPart", this.partName);
            nbtTask.func_74757_a("TargetTitle", this.andTitle);
            nbtTask.func_74757_a("NotShowLogEntity", this.notShowLogEntity);
        }
        if (this.type == EnumQuestTask.AREAKILL) {
            nbtTask.func_74768_a("Range", this.range);
        }
        if (!this.item.func_190926_b()) {
            nbtTask.func_74782_a("Item", (NBTBase)this.item.func_77955_b(new NBTTagCompound()));
            nbtTask.func_74757_a("LeaveItem", this.leaveItem);
            nbtTask.func_74757_a("IgnoreDamage", this.ignoreDamage);
            nbtTask.func_74757_a("IgnoreNBT", this.ignoreNBT);
        }
        return nbtTask;
    }

    @Override
    public String getOrientationEntityName() {
        return this.entityName;
    }

    @Override
    public int getProgress() {
        if (this.type == EnumQuestTask.ITEM) {
            int count = 0;
            for (int i = 0; i < Objects.requireNonNull(this.player).field_71071_by.func_70302_i_(); ++i) {
                ItemStack item = this.player.field_71071_by.func_70301_a(i);
                if (NoppesUtilServer.IsItemStackNull(item) || !NoppesUtilPlayer.compareItems(item, item, this.ignoreDamage, this.ignoreNBT)) continue;
                count += item.func_190916_E();
            }
            return ValueUtil.correctInt(count, 0, this.maxProgress);
        }
        PlayerData data = PlayerData.get(this.player);
        QuestData questData = data.questData.activeQuests.get(this.parentID);
        if (this.type == EnumQuestTask.DIALOG) {
            return data.dialogData.has(this.id) ? 1 : 0;
        }
        if (this.type == EnumQuestTask.LOCATION) {
            for (NBTBase dataNBT : questData.extraData.func_150295_c("Locations", 10)) {
                if (!this.name.equalsIgnoreCase(((NBTTagCompound)dataNBT).func_74779_i("Location"))) continue;
                return ((NBTTagCompound)dataNBT).func_74767_n("Found") ? 1 : 0;
            }
            return 0;
        }
        if (questData == null) {
            return 0;
        }
        if (this.type == EnumQuestTask.KILL || this.type == EnumQuestTask.AREAKILL || this.type == EnumQuestTask.MANUAL) {
            HashMap<String, Integer> killed = this.getKilled(questData);
            if (!killed.containsKey(this.name)) {
                return 0;
            }
            return killed.get(this.name);
        }
        if (this.type == EnumQuestTask.CRAFT) {
            HashMap<ItemStack, Integer> crafted = this.getCrafted(questData);
            for (ItemStack item : crafted.keySet()) {
                if (!NoppesUtilPlayer.compareItems(this.item, item, this.ignoreDamage, this.ignoreNBT)) continue;
                return crafted.get(item);
            }
        }
        return 0;
    }

    @Override
    public int getTargetID() {
        return this.id;
    }

    @Override
    public String getTargetName() {
        return this.name;
    }

    @Override
    public String getText() {
        String colorD = "\u00a74";
        String colorG = "\u00a72";
        String colorR = "\u00a7r";
        if (this.type == EnumQuestTask.ITEM) {
            return this.item.func_82833_r() + ": " + (this.isCompleted() ? colorG : colorD) + this.getProgress() + colorR + "/" + this.getMaxProgress() + (this.leaveItem ? new TextComponentTranslation("quest.take.log", new Object[0]).func_150254_d() : "");
        }
        if (this.type == EnumQuestTask.CRAFT) {
            return this.item.func_82833_r() + ": " + (this.isCompleted() ? colorG : colorD) + this.getProgress() + colorR + "/" + this.getMaxProgress() + (this.leaveItem ? new TextComponentTranslation("quest.take.log", new Object[0]).func_150254_d() : "");
        }
        if (this.type == EnumQuestTask.DIALOG) {
            String done = new TextComponentTranslation("quest.task.dialog." + (!this.isCompleted() ? "1" : "0"), new Object[0]).func_150254_d();
            String name = "null";
            Dialog dialog = DialogController.instance.dialogs.get(this.id);
            if (dialog != null) {
                name = new TextComponentTranslation(dialog.title, new Object[0]).func_150254_d();
            }
            return (this.isCompleted() ? colorG : colorD) + name + colorR + done;
        }
        if (this.type == EnumQuestTask.KILL || this.type == EnumQuestTask.AREAKILL) {
            String locName = "entity." + this.name + ".name";
            String transName = new TextComponentTranslation(locName, new Object[0]).func_150254_d();
            if (transName.contains("entity.") && transName.indexOf(".name") > 0) {
                transName = this.name;
            }
            return transName + ": " + (this.isCompleted() ? colorG : colorD) + this.getProgress() + colorR + "/" + this.getMaxProgress();
        }
        if (this.type == EnumQuestTask.LOCATION) {
            String done = new TextComponentTranslation("quest.task.location." + (!this.isCompleted() ? "1" : "0"), new Object[0]).func_150254_d();
            return (this.isCompleted() ? colorG : colorD) + new TextComponentTranslation(this.name, new Object[0]).func_150254_d() + colorR + ": " + done;
        }
        if (this.type == EnumQuestTask.MANUAL) {
            return new TextComponentTranslation(this.name, new Object[0]).func_150254_d() + ": " + (this.isCompleted() ? colorG : colorD) + this.getProgress() + colorR + "/" + this.getMaxProgress();
        }
        return "null type: " + (Object)((Object)this.type) + " #" + this.toString().substring(this.toString().indexOf("@") + 1);
    }

    @Override
    public int getType() {
        return this.type.ordinal();
    }

    @Override
    public boolean isAndTitle() {
        return this.andTitle;
    }

    @Override
    public boolean isCompleted() {
        if (this.type == EnumQuestTask.ITEM) {
            return NoppesUtilPlayer.compareItems(this.player, this.item, this.ignoreDamage, this.ignoreNBT, this.maxProgress);
        }
        if (this.type == EnumQuestTask.DIALOG) {
            return PlayerData.get((EntityPlayer)this.player).dialogData.has(this.id);
        }
        return this.getProgress() >= this.maxProgress;
    }

    @Override
    public boolean isIgnoreDamage() {
        return this.ignoreDamage;
    }

    @Override
    public boolean isItemIgnoreNBT() {
        return this.ignoreNBT;
    }

    @Override
    public boolean isItemLeave() {
        return this.leaveItem;
    }

    @Override
    public boolean isNotShowLogEntity() {
        return this.notShowLogEntity;
    }

    @Override
    public boolean isPartName() {
        return this.partName;
    }

    @Override
    public boolean isSetPointOnMiniMap() {
        return this.setPointOnMiniMap;
    }

    public void load(NBTTagCompound nbtTask) {
        this.type = EnumQuestTask.values()[nbtTask.func_74762_e("Type")];
        this.setPointOnMiniMap = nbtTask.func_74767_n("SetPointOnMiniMap");
        if (nbtTask.func_150297_b("CompassData", 10)) {
            NBTTagCompound nbtCompass = nbtTask.func_74775_l("CompassData");
            int[] bp = nbtCompass.func_74759_k("Pos");
            this.pos = new BlockPos(bp[0], bp[1], bp[2]);
            this.dimensionID = nbtCompass.func_74762_e("DimensionID");
            if (nbtCompass.func_150297_b("RegionID", 3)) {
                this.regionID = nbtCompass.func_74762_e("RegionID");
            }
            this.rangeCompass = nbtCompass.func_74762_e("Range");
            this.entityName = nbtCompass.func_74779_i("EntityName");
        }
        if (nbtTask.func_150297_b("Progress", 3)) {
            this.setMaxProgress(nbtTask.func_74762_e("Progress"));
        }
        if (nbtTask.func_150297_b("TargetID", 3)) {
            this.setTargetID(nbtTask.func_74762_e("TargetID"));
        }
        if (nbtTask.func_150297_b("TargetName", 8)) {
            this.setTargetName(nbtTask.func_74779_i("TargetName"));
            this.partName = nbtTask.func_74767_n("TargetPart");
            this.andTitle = nbtTask.func_74767_n("TargetTitle");
            this.notShowLogEntity = nbtTask.func_74767_n("NotShowLogEntity");
        }
        if (nbtTask.func_150297_b("Range", 3)) {
            this.setAreaRange(nbtTask.func_74762_e("Range"));
        }
        if (nbtTask.func_150297_b("Item", 10)) {
            this.setItem(new ItemStack(nbtTask.func_74775_l("Item")));
            this.leaveItem = nbtTask.func_74767_n("LeaveItem");
            this.ignoreDamage = nbtTask.func_74767_n("IgnoreDamage");
            this.ignoreNBT = nbtTask.func_74767_n("IgnoreNBT");
        }
    }

    @Override
    public void setAndTitle(boolean addTitle) {
        this.andTitle = addTitle;
    }

    @Override
    public void setAreaRange(int range) {
        if (range < 3 || range > 32) {
            throw new CustomNPCsException("Range must be between 3 and 32", new Object[0]);
        }
        this.range = range;
    }

    @Override
    public void setCompassDimension(int dimensionID) {
        if (DimensionManager.isDimensionRegistered((int)dimensionID)) {
            throw new CustomNPCsException("Dimension ID:" + dimensionID + " not found", new Object[0]);
        }
        this.dimensionID = dimensionID;
    }

    @Override
    public void setCompassPos(int x, int y, int z) {
        this.pos = new BlockPos(x, y, z);
    }

    @Override
    public void setCompassPos(IPos pos) {
        this.pos = pos.getMCBlockPos();
    }

    @Override
    public void setCompassRange(int range) {
        if (range < 0 || range > 64) {
            throw new CustomNPCsException("Compass Range must be between 3 and 64", new Object[0]);
        }
        this.rangeCompass = range;
    }

    public void setCrafted(QuestData data, HashMap<ItemStack, Integer> crafted) {
        data.extraData.func_74782_a("Crafts", (NBTBase)NBTTags.nbtItemStackIntegerMap(crafted));
    }

    @Override
    public void setItem(IItemStack item) {
        this.item = item.getMCItemStack();
    }

    public void setItem(ItemStack item) {
        this.item = item;
    }

    @Override
    public void setItemIgnoreDamage(boolean bo) {
        this.ignoreDamage = bo;
    }

    @Override
    public void setItemIgnoreNBT(boolean bo) {
        this.ignoreNBT = bo;
    }

    @Override
    public void setItemLeave(boolean bo) {
        this.leaveItem = bo;
    }

    public void setKilled(QuestData data, HashMap<String, Integer> killed) {
        data.extraData.func_74782_a("Targets", (NBTBase)NBTTags.nbtStringIntegerMap(killed));
    }

    @Override
    public void setMaxProgress(int value) {
        if (value < 1 || value > 10000000) {
            throw new CustomNPCsException("Progress must be between 1 and 10000000", new Object[0]);
        }
        if ((this.type == EnumQuestTask.DIALOG || this.type == EnumQuestTask.LOCATION) && value > 1) {
            throw new CustomNPCsException("Progress has to be 0 or 1", new Object[0]);
        }
        this.maxProgress = value;
    }

    @Override
    public void setNotShowLogEntity(boolean notShowLogEntity) {
        this.notShowLogEntity = notShowLogEntity;
    }

    @Override
    public void setOrientationEntityName(String name) {
        this.entityName = name;
    }

    @Override
    public void setPartName(boolean isPart) {
        this.partName = isPart;
    }

    @Override
    public void setPointOnMiniMap(boolean bo) {
        this.setPointOnMiniMap = bo;
    }

    @Override
    public void setProgress(int progress) {
        if (this.type == EnumQuestTask.ITEM) {
            throw new CustomNPCsException("Cant set the progress of ItemTask", new Object[0]);
        }
        PlayerData data = PlayerData.get(this.player);
        QuestData questData = data.questData.activeQuests.get(this.parentID);
        if (this.type == EnumQuestTask.DIALOG) {
            if (progress < 0 || progress > 1) {
                throw new CustomNPCsException("Progress has to be 0 or 1", new Object[0]);
            }
            boolean completed = data.dialogData.has(this.id);
            if (progress == 0 && completed) {
                data.dialogData.dialogsRead.remove(this.id);
            } else if (progress == 1 && !completed) {
                data.dialogData.read(this.id);
            } else {
                return;
            }
            if (progress == 1) {
                String dialog = "dialog ID:" + this.id;
                Dialog d = DialogController.instance.get(this.id);
                if (d != null) {
                    dialog = d.getName();
                }
                if (questData.quest.showProgressInWindow) {
                    NBTTagCompound compound = new NBTTagCompound();
                    compound.func_74768_a("QuestID", questData.quest.id);
                    compound.func_74778_a("Type", "dialog");
                    compound.func_74783_a("Progress", new int[]{progress, 1});
                    compound.func_74778_a("TargetName", dialog);
                    compound.func_74768_a("MessageType", 0);
                    Server.sendData((EntityPlayerMP)this.player, EnumPacketClient.MESSAGE_DATA, compound);
                }
                if (this.player != null && questData.quest.showProgressInChat) {
                    this.player.func_145747_a((ITextComponent)new TextComponentTranslation("quest.message.dialog." + progress, new Object[]{new TextComponentTranslation(dialog, new Object[0]).func_150254_d(), questData.quest.getTitle()}));
                }
            }
            data.updateClient = true;
        } else if (this.type == EnumQuestTask.LOCATION) {
            Object dataNBT;
            if (progress < 0 || progress > 1) {
                throw new CustomNPCsException("Progress has to be 0 or 1", new Object[0]);
            }
            if (!questData.extraData.func_150297_b("Locations", 9)) {
                NBTTagList list = new NBTTagList();
                dataNBT = new NBTTagCompound();
                dataNBT.func_74778_a("Location", this.name);
                dataNBT.func_74757_a("Found", progress == 1);
                list.func_74742_a((NBTBase)dataNBT);
                questData.extraData.func_74782_a("Locations", (NBTBase)list);
            } else {
                boolean found = false;
                for (NBTBase dataNBT2 : questData.extraData.func_150295_c("Locations", 10)) {
                    if (!this.name.equalsIgnoreCase(((NBTTagCompound)dataNBT2).func_74779_i("Location"))) continue;
                    boolean completed = ((NBTTagCompound)dataNBT2).func_74767_n("Found");
                    if (completed && progress == 1 || !completed && progress == 0) {
                        return;
                    }
                    ((NBTTagCompound)dataNBT2).func_74757_a("Found", progress == 1);
                    found = true;
                    break;
                }
                if (!found) {
                    dataNBT = new NBTTagCompound();
                    dataNBT.func_74778_a("Location", this.name);
                    dataNBT.func_74757_a("Found", progress == 1);
                    questData.extraData.func_150295_c("Locations", 10).func_74742_a((NBTBase)dataNBT);
                }
            }
            if (progress == 1) {
                NBTTagCompound compound = new NBTTagCompound();
                compound.func_74768_a("QuestID", questData.quest.id);
                compound.func_74778_a("Type", "location");
                compound.func_74783_a("Progress", new int[]{progress, 1});
                compound.func_74778_a("TargetName", this.name);
                compound.func_74768_a("MessageType", 0);
                Server.sendData((EntityPlayerMP)this.player, EnumPacketClient.MESSAGE_DATA, compound);
                if (this.player != null) {
                    this.player.func_145747_a((ITextComponent)new TextComponentTranslation("quest.message.location." + progress, new Object[]{new TextComponentTranslation(this.name, new Object[0]).func_150254_d(), questData.quest.getTitle()}));
                }
            }
            data.updateClient = true;
        } else if (this.type == EnumQuestTask.KILL || this.type == EnumQuestTask.AREAKILL || this.type == EnumQuestTask.MANUAL) {
            Object key;
            if (progress < 0 || progress > this.maxProgress) {
                throw new CustomNPCsException("Progress has to be between 0 and " + this.maxProgress, new Object[0]);
            }
            HashMap<String, Integer> killed = this.getKilled(questData);
            if (killed.containsKey(this.name) && killed.get(this.name) == progress) {
                return;
            }
            Object object = key = this.type == EnumQuestTask.MANUAL ? "manual" : "kill";
            if (killed.get(this.name) < progress) {
                NBTTagCompound compound = new NBTTagCompound();
                compound.func_74768_a("QuestID", questData.quest.id);
                compound.func_74778_a("Type", (String)key);
                compound.func_74783_a("Progress", new int[]{progress, this.maxProgress});
                compound.func_74778_a("TargetName", this.name);
                compound.func_74768_a("MessageType", 0);
                Server.sendData((EntityPlayerMP)this.player, EnumPacketClient.MESSAGE_DATA, compound);
                if (this.player != null) {
                    this.player.func_145747_a((ITextComponent)new TextComponentTranslation("quest.message." + (String)key + ".0", new Object[]{new TextComponentTranslation(this.name, new Object[0]).func_150254_d(), "" + progress, "" + this.maxProgress, questData.quest.getTitle()}));
                }
            }
            killed.put(this.name, progress);
            this.setKilled(questData, killed);
            if (this.player != null && progress >= this.maxProgress) {
                this.player.func_145747_a((ITextComponent)new TextComponentTranslation("quest.message." + (String)key + ".1", new Object[]{new TextComponentTranslation(this.name, new Object[0]).func_150254_d(), questData.quest.getTitle()}));
            }
            data.updateClient = true;
        } else if (this.type == EnumQuestTask.CRAFT) {
            if (progress < 0 || progress > this.maxProgress) {
                throw new CustomNPCsException("Progress has to be between 0 and " + this.maxProgress, new Object[0]);
            }
            HashMap<ItemStack, Integer> crafted = this.getCrafted(questData);
            for (ItemStack item : crafted.keySet()) {
                if (!NoppesUtilPlayer.compareItems(this.item, item, this.ignoreDamage, this.ignoreNBT) || crafted.get(item) == progress) continue;
                crafted.put(item, progress);
                break;
            }
            this.setCrafted(questData, crafted);
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74768_a("QuestID", questData.quest.id);
            compound.func_74778_a("Type", "craft");
            compound.func_74783_a("Progress", new int[]{progress, this.maxProgress});
            compound.func_74778_a("TargetName", this.item.func_82833_r());
            compound.func_74768_a("MessageType", 0);
            Server.sendData((EntityPlayerMP)this.player, EnumPacketClient.MESSAGE_DATA, compound);
            if (this.player != null) {
                if (progress >= this.maxProgress) {
                    this.player.func_145747_a((ITextComponent)new TextComponentTranslation("quest.message.craft.1", new Object[]{this.item.func_82833_r(), questData.quest.getTitle()}));
                } else {
                    this.player.func_145747_a((ITextComponent)new TextComponentTranslation("quest.message.craft.0", new Object[]{this.item.func_82833_r(), "" + progress, "" + this.maxProgress, questData.quest.getTitle()}));
                }
            }
            data.updateClient = true;
        }
        for (IQuestObjective obj : questData.quest.getObjectives((IPlayer)Objects.requireNonNull(NpcAPI.Instance()).getIEntity((Entity)this.player))) {
            if (((QuestObjective)obj).getEnumType() != this.type) continue;
            data.questData.checkQuestCompletion(this.player, questData);
        }
    }

    @Override
    public void setTargetID(int id) {
        if (id < 0) {
            throw new CustomNPCsException("Task ID must be greater than 0", new Object[0]);
        }
        this.id = id;
    }

    @Override
    public void setTargetName(String name) {
        if (name == null) {
            name = "";
        }
        this.name = name;
    }

    public void setType(EnumQuestTask type) {
        this.type = type;
    }

    @Override
    public void setType(int type) {
        if (type < 0 || type >= EnumQuestTask.values().length) {
            throw new CustomNPCsException("Type must be between 0 and " + (EnumQuestTask.values().length - 1), new Object[0]);
        }
        this.type = EnumQuestTask.values()[type];
    }
}

